/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.config.templates.ExpressionEvaluationException;
import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoleBasedFieldAuthorization
implements ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(RoleBasedFieldAuthorization.class);
    private final SgDynamicConfiguration<Role> roles;
    private final StaticIndexRules staticIndexQueries;
    private volatile StatefulIndexRules statefulIndexQueries;
    private final ComponentState componentState = new ComponentState("role_based_field_authorization");

    public RoleBasedFieldAuthorization(SgDynamicConfiguration<Role> roles, Set<String> indices, MetricsLevel metricsLevel) {
        this.roles = roles;
        this.staticIndexQueries = new StaticIndexRules(roles);
        this.statefulIndexQueries = new StatefulIndexRules(roles, indices);
        this.componentState.setInitialized();
        this.componentState.setConfigVersion(roles.getDocVersion());
        this.componentState.addPart(this.staticIndexQueries.getComponentState());
        this.componentState.addPart(this.statefulIndexQueries.getComponentState());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public FlsRule getFlsRule(PrivilegesEvaluationContext context, String index, Meter meter) throws PrivilegesEvaluationException {
        try (Meter subMeter = meter.detail("evaluate_fls");){
            Object object;
            if (this.staticIndexQueries.rolesWithIndexWildcardWithoutRule.containsAny((Collection)context.getMappedRoles())) {
                FlsRule flsRule = FlsRule.ALLOW_ALL;
                return flsRule;
            }
            StatefulIndexRules statefulIndexQueries = this.statefulIndexQueries;
            if (!statefulIndexQueries.indices.contains((Object)index)) {
                if (log.isDebugEnabled()) {
                    log.debug("Index {} do not exist. Assuming full field restriction.", (Object)index);
                }
                FlsRule flsRule = FlsRule.DENY_ALL;
                return flsRule;
            }
            ImmutableSet rolesWithoutRule = (ImmutableSet)statefulIndexQueries.indexToRoleWithoutRule.get((Object)index);
            if (rolesWithoutRule != null && rolesWithoutRule.containsAny((Collection)context.getMappedRoles())) {
                FlsRule flsRule = FlsRule.ALLOW_ALL;
                return flsRule;
            }
            ImmutableMap roleToRule = (ImmutableMap)this.statefulIndexQueries.indexToRoleToRule.get((Object)index);
            ArrayList<FlsRule> rules = new ArrayList<FlsRule>();
            for (String role : context.getMappedRoles()) {
                ImmutableMap indexPatternTemplateToQuery;
                FlsRule rule = (FlsRule)this.staticIndexQueries.roleWithIndexWildcardToRule.get((Object)role);
                if (rule != null) {
                    rules.add(rule);
                }
                if (roleToRule != null && (rule = (FlsRule)roleToRule.get((Object)role)) != null) {
                    rules.add(rule);
                }
                if ((indexPatternTemplateToQuery = (ImmutableMap)this.staticIndexQueries.rolesToIndexPatternTemplateToRule.get((Object)role)) == null) continue;
                for (Map.Entry entry : indexPatternTemplateToQuery.entrySet()) {
                    try {
                        Pattern pattern = context.getRenderedPattern(((Role.IndexPatterns.IndexPatternTemplate)entry.getKey()).getTemplate());
                        if (!pattern.matches(index) || ((Role.IndexPatterns.IndexPatternTemplate)entry.getKey()).getExclusions().matches(index)) continue;
                        rules.add((FlsRule)entry.getValue());
                    }
                    catch (ExpressionEvaluationException e) {
                        throw new PrivilegesEvaluationException("Error while rendering index pattern of role " + role, (Throwable)e);
                    }
                }
            }
            if (rules.isEmpty()) {
                object = FlsRule.ALLOW_ALL;
                return object;
            }
            object = FlsRule.merge(rules);
            return object;
        }
        catch (PrivilegesEvaluationException e) {
            this.componentState.addLastException("evaluate", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.componentState.addLastException("evaluate_u", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasFlsRestrictions(PrivilegesEvaluationContext context, Collection<String> indices, Meter meter) throws PrivilegesEvaluationException {
        try (Meter subMeter = meter.detail("has_fls_restriction");){
            if (this.staticIndexQueries.rolesWithIndexWildcardWithoutRule.containsAny((Collection)context.getMappedRoles())) {
                boolean bl = false;
                return bl;
            }
            StatefulIndexRules statefulIndexQueries = this.statefulIndexQueries;
            if (!statefulIndexQueries.indices.containsAll(indices)) {
                if (log.isDebugEnabled()) {
                    log.debug("Indices {} do not exist. Assuming full field restriction.", indices);
                }
                boolean bl = true;
                return bl;
            }
            for (String index : indices) {
                if (!this.hasFlsRestrictions(context, index, statefulIndexQueries)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (PrivilegesEvaluationException e) {
            this.componentState.addLastException("has_restriction", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.componentState.addLastException("has_restriction_u", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasFlsRestrictions(PrivilegesEvaluationContext context, String index, Meter meter) throws PrivilegesEvaluationException {
        try (Meter subMeter = meter.detail("has_fls_restriction");){
            if (this.staticIndexQueries.rolesWithIndexWildcardWithoutRule.containsAny((Collection)context.getMappedRoles())) {
                boolean bl = false;
                return bl;
            }
            StatefulIndexRules statefulIndexQueries = this.statefulIndexQueries;
            if (!statefulIndexQueries.indices.contains((Object)index)) {
                if (log.isDebugEnabled()) {
                    log.debug("Index {} do not exist. Assuming full field restriction.", (Object)index);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = this.hasFlsRestrictions(context, index, statefulIndexQueries);
            return bl;
        }
        catch (PrivilegesEvaluationException e) {
            this.componentState.addLastException("has_restriction", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.componentState.addLastException("has_restriction_u", (Throwable)e);
            throw e;
        }
    }

    private boolean hasFlsRestrictions(PrivilegesEvaluationContext context, String index, StatefulIndexRules statefulIndexQueries) throws PrivilegesEvaluationException {
        ImmutableSet roleWithoutRule = (ImmutableSet)statefulIndexQueries.indexToRoleWithoutRule.get((Object)index);
        if (roleWithoutRule != null && roleWithoutRule.containsAny((Collection)context.getMappedRoles())) {
            return false;
        }
        ImmutableMap roleToRule = (ImmutableMap)statefulIndexQueries.indexToRoleToRule.get((Object)index);
        for (String role : context.getMappedRoles()) {
            FlsRule rule = (FlsRule)this.staticIndexQueries.roleWithIndexWildcardToRule.get((Object)role);
            if (rule != null) {
                return true;
            }
            if (roleToRule != null && (rule = (FlsRule)roleToRule.get((Object)role)) != null) {
                return true;
            }
            ImmutableMap indexPatternTemplateToRule = (ImmutableMap)this.staticIndexQueries.rolesToIndexPatternTemplateToRule.get((Object)role);
            if (indexPatternTemplateToRule == null) continue;
            for (Map.Entry entry : indexPatternTemplateToRule.entrySet()) {
                try {
                    Pattern pattern = context.getRenderedPattern(((Role.IndexPatterns.IndexPatternTemplate)entry.getKey()).getTemplate());
                    if (!pattern.matches(index) || ((Role.IndexPatterns.IndexPatternTemplate)entry.getKey()).getExclusions().matches(index)) continue;
                    return true;
                }
                catch (ExpressionEvaluationException e) {
                    throw new PrivilegesEvaluationException("Error while rendering index pattern of role " + role, (Throwable)e);
                }
            }
        }
        return false;
    }

    public synchronized void updateIndices(Set<String> indices) {
        StatefulIndexRules statefulIndexQueries = this.statefulIndexQueries;
        if (!statefulIndexQueries.indices.equals(indices)) {
            this.statefulIndexQueries = new StatefulIndexRules(this.roles, indices);
            this.componentState.replacePart(this.statefulIndexQueries.getComponentState());
        }
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    public static abstract class FlsRule {
        public static final FlsRule ALLOW_ALL = new SingleRole((ImmutableList<Role.Index.FlsPattern>)ImmutableList.empty());
        public static final FlsRule DENY_ALL = new SingleRole((ImmutableList<Role.Index.FlsPattern>)ImmutableList.of((Object)Role.Index.FlsPattern.EXCLUDE_ALL));

        public static FlsRule of(String ... rules) throws ConfigValidationException {
            ImmutableList.Builder patterns = new ImmutableList.Builder();
            for (String rule : rules) {
                patterns.add((Object)new Role.Index.FlsPattern(rule));
            }
            return new SingleRole((ImmutableList<Role.Index.FlsPattern>)patterns.build());
        }

        static FlsRule merge(List<FlsRule> rules) {
            if (rules.size() == 1) {
                return rules.get(0);
            }
            ImmutableList.Builder entries = new ImmutableList.Builder(rules.size());
            for (FlsRule rule : rules) {
                if (rule instanceof SingleRole) {
                    entries.add((Object)((SingleRole)rule));
                    continue;
                }
                if (!(rule instanceof MultiRole)) continue;
                for (SingleRole subRule : ((MultiRole)rule).entries) {
                    entries.add((Object)subRule);
                }
            }
            return new MultiRole((ImmutableList<SingleRole>)entries.build());
        }

        public abstract boolean isAllowed(String var1);

        public abstract boolean isAllowAll();

        static String stripKeywordSuffix(String field) {
            if (field.endsWith(".keyword")) {
                return field.substring(0, field.length() - ".keyword".length());
            }
            return field;
        }

        static class MultiRole
        extends FlsRule {
            final ImmutableList<SingleRole> entries;
            final Map<String, Boolean> cache;
            final boolean allowAll;

            MultiRole(ImmutableList<SingleRole> entries) {
                this.entries = entries;
                this.allowAll = entries.forAnyApplies(e -> e.isAllowAll());
                this.cache = this.allowAll ? null : new ConcurrentHashMap<String, Boolean>();
            }

            @Override
            public boolean isAllowed(String field) {
                if (this.allowAll) {
                    return true;
                }
                if (this.cache == null) {
                    return this.internalIsAllowed(field);
                }
                Boolean allowed = this.cache.get(field);
                if (allowed != null) {
                    return allowed;
                }
                allowed = this.internalIsAllowed(field);
                this.cache.put(field, allowed);
                return allowed;
            }

            private boolean internalIsAllowed(String field) {
                field = MultiRole.stripKeywordSuffix(field);
                for (SingleRole entry : this.entries) {
                    if (!entry.isAllowed(field)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isAllowAll() {
                return this.allowAll;
            }

            public String toString() {
                if (this.isAllowAll()) {
                    return "FLS:*";
                }
                return "FLS:" + this.entries.map(e -> e.patterns);
            }
        }

        static class SingleRole
        extends FlsRule {
            final Role sourceRole;
            final Role.Index sourceIndex;
            final ImmutableList<Role.Index.FlsPattern> patterns;
            final Map<String, Boolean> cache;
            final boolean allowAll;

            SingleRole(Role sourceRole, Role.Index sourceIndex) {
                this.sourceRole = sourceRole;
                this.sourceIndex = sourceIndex;
                int exclusions = 0;
                int inclusions = 0;
                for (Role.Index.FlsPattern pattern : sourceIndex.getFls()) {
                    if (pattern.isExcluded()) {
                        ++exclusions;
                        continue;
                    }
                    ++inclusions;
                }
                this.patterns = exclusions == 0 && inclusions == 0 ? ImmutableList.of((Object)Role.Index.FlsPattern.INCLUDE_ALL) : (exclusions != 0 && inclusions == 0 ? ImmutableList.of((Object)Role.Index.FlsPattern.INCLUDE_ALL).with((Collection)sourceIndex.getFls()) : (exclusions == 0 && inclusions != 0 ? ImmutableList.of((Object)Role.Index.FlsPattern.EXCLUDE_ALL).with((Collection)sourceIndex.getFls()) : sourceIndex.getFls()));
                this.allowAll = this.patterns.isEmpty() || this.patterns.size() == 1 && ((Role.Index.FlsPattern)this.patterns.get(0)).getPattern().isWildcard() && !((Role.Index.FlsPattern)this.patterns.get(0)).isExcluded();
                this.cache = this.allowAll ? null : new ConcurrentHashMap<String, Boolean>();
            }

            public SingleRole(ImmutableList<Role.Index.FlsPattern> patterns) {
                this.patterns = patterns;
                this.sourceIndex = null;
                this.sourceRole = null;
                this.allowAll = patterns.isEmpty() || patterns.size() == 1 && ((Role.Index.FlsPattern)patterns.get(0)).getPattern().isWildcard() && !((Role.Index.FlsPattern)patterns.get(0)).isExcluded();
                this.cache = null;
            }

            @Override
            public boolean isAllowed(String field) {
                if (this.cache == null) {
                    return this.internalIsAllowed(field);
                }
                Boolean allowed = this.cache.get(field);
                if (allowed != null) {
                    return allowed;
                }
                allowed = this.internalIsAllowed(field);
                this.cache.put(field, allowed);
                return allowed;
            }

            private boolean internalIsAllowed(String field) {
                field = SingleRole.stripKeywordSuffix(field);
                boolean allowed = true;
                for (Role.Index.FlsPattern pattern : this.patterns) {
                    if (!pattern.getPattern().matches(field)) continue;
                    if (pattern.isExcluded()) {
                        allowed = false;
                        continue;
                    }
                    allowed = true;
                }
                return allowed;
            }

            @Override
            public boolean isAllowAll() {
                return this.allowAll;
            }

            public String toString() {
                if (this.isAllowAll()) {
                    return "FLS:*";
                }
                return "FLS:" + this.patterns;
            }
        }
    }

    static class StatefulIndexRules
    implements ComponentStateProvider {
        private final ImmutableMap<String, ImmutableMap<String, FlsRule>> indexToRoleToRule;
        private final ImmutableMap<String, ImmutableSet<String>> indexToRoleWithoutRule;
        private final ImmutableSet<String> indices;
        private final ImmutableMap<String, ImmutableList<Exception>> rolesToInitializationErrors;
        private final ComponentState componentState;

        StatefulIndexRules(SgDynamicConfiguration<Role> roles, Set<String> indices) {
            this.indices = ImmutableSet.of(indices);
            this.componentState = new ComponentState("stateful_index_queries");
            ImmutableMap.Builder indexToRoleToRule = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder());
            ImmutableMap.Builder indexToRoleWithoutRule = new ImmutableMap.Builder().defaultValue(k -> new ImmutableSet.Builder());
            ImmutableMap.Builder rolesToInitializationErrors = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    for (Role.Index indexPermissions : role.getIndexPermissions()) {
                        Pattern indexPattern = indexPermissions.getIndexPatterns().getPattern();
                        if (indexPattern.isWildcard() || indexPattern.isBlank()) continue;
                        ImmutableList flsPatterns = indexPermissions.getFls();
                        if (flsPatterns != null && !flsPatterns.isEmpty()) {
                            FlsRule.SingleRole flsRule = new FlsRule.SingleRole(role, indexPermissions);
                            for (String index : indexPattern.iterateMatching(indices)) {
                                ((ImmutableMap.Builder)indexToRoleToRule.get((Object)index)).put((Object)roleName, (Object)flsRule);
                            }
                            continue;
                        }
                        for (String index : indexPattern.iterateMatching(indices)) {
                            ((ImmutableSet.Builder)indexToRoleWithoutRule.get((Object)index)).add((Object)roleName);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: " + entry + "\nIgnoring role.", (Throwable)e);
                    ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)((String)entry.getKey()))).with((Object)e);
                }
            }
            this.indexToRoleToRule = indexToRoleToRule.build(b -> b.build());
            this.indexToRoleWithoutRule = indexToRoleWithoutRule.build(b -> b.build());
            this.rolesToInitializationErrors = rolesToInitializationErrors.build(b -> b.build());
            if (this.rolesToInitializationErrors.isEmpty()) {
                this.componentState.initialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "roles_with_errors");
                this.componentState.addDetail((Object)rolesToInitializationErrors);
            }
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }

    static class StaticIndexRules
    implements ComponentStateProvider {
        private final ComponentState componentState = new ComponentState("static_index_rules");
        private final ImmutableSet<String> rolesWithIndexWildcardWithoutRule;
        private final ImmutableMap<String, FlsRule> roleWithIndexWildcardToRule;
        private final ImmutableMap<String, ImmutableMap<Role.IndexPatterns.IndexPatternTemplate, FlsRule>> rolesToIndexPatternTemplateToRule;
        private final ImmutableMap<String, ImmutableList<Exception>> rolesToInitializationErrors;

        StaticIndexRules(SgDynamicConfiguration<Role> roles) {
            ImmutableSet.Builder rolesWithIndexWildcardWithoutRule = new ImmutableSet.Builder();
            ImmutableMap.Builder roleWithIndexWildcardToRule = new ImmutableMap.Builder();
            ImmutableMap.Builder rolesToIndexPatternTemplateToRule = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder());
            ImmutableMap.Builder rolesToInitializationErrors = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    for (Role.Index indexPermissions : role.getIndexPermissions()) {
                        if (indexPermissions.getIndexPatterns().getPattern().isWildcard()) {
                            ImmutableList flsPatterns = indexPermissions.getFls();
                            if (flsPatterns == null || flsPatterns.isEmpty()) {
                                rolesWithIndexWildcardWithoutRule.add((Object)roleName);
                                continue;
                            }
                            FlsRule.SingleRole flsRule = new FlsRule.SingleRole(role, indexPermissions);
                            roleWithIndexWildcardToRule.put((Object)roleName, (Object)flsRule);
                            continue;
                        }
                        for (Role.IndexPatterns.IndexPatternTemplate indexPatternTemplate : indexPermissions.getIndexPatterns().getPatternTemplates()) {
                            ImmutableList flsPatterns = indexPermissions.getFls();
                            if (flsPatterns == null || flsPatterns.isEmpty()) continue;
                            FlsRule.SingleRole flsRule = new FlsRule.SingleRole(role, indexPermissions);
                            ((ImmutableMap.Builder)rolesToIndexPatternTemplateToRule.get((Object)roleName)).put((Object)indexPatternTemplate, (Object)flsRule);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: " + entry + "\nIgnoring role.", (Throwable)e);
                    ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)((String)entry.getKey()))).with((Object)e);
                }
            }
            this.rolesWithIndexWildcardWithoutRule = rolesWithIndexWildcardWithoutRule.build();
            this.roleWithIndexWildcardToRule = roleWithIndexWildcardToRule.build();
            this.rolesToIndexPatternTemplateToRule = rolesToIndexPatternTemplateToRule.build(b -> b.build());
            this.rolesToInitializationErrors = rolesToInitializationErrors.build(b -> b.build());
            if (this.rolesToInitializationErrors.isEmpty()) {
                this.componentState.initialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "roles_with_errors");
                this.componentState.addDetail((Object)rolesToInitializationErrors);
            }
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }
}

